// Original Ingot Box Author Unknown
// Scripted by Karmageddon
using Server.ContextMenus;
using Server.Gumps;
using Server.Mobiles;
using Server.Network;
using Server.Targeting;
using System.Collections.Generic;
using Xanthos.ShrinkSystem;

namespace Server.Items
{
    [FlipableAttribute(0xE79, 0x9B0)]
    public class PotionPouch : BaseContainer
    {
        private int m_TotalRefreshPotion;
        private int m_GreaterAgilityPotion;
        private int m_NightSightPotion;
        private int m_GreaterHealPotion;
        private int m_GreaterStrengthPotion;
        private int m_GreaterPoisonPotion;
        private int m_DeadlyPoisonPotion;
        private int m_LethalPoisonPotion;
        private int m_GreaterCurePotion;
        private int m_GreaterExplosionPotion;
        private int m_SmokeBomb;
        private int m_ManaPotion;
        private int m_TotalManaRefreshPotion;
        private int m_ShrinkPotions;
        private int m_PetResurrectPotion;
        private int m_RepairPotion;
        private int m_SuperPotion;
        private int m_MortarPestle;
        private int m_Bottle;
        private int m_WithdrawIncrement;
        private int m_KulickyCesnek;
        private int m_KulickyPikant;
        private int m_Medovina;
        private int m_ZoogiVejce;
        private int m_PekelnyParek;
        private int m_Slzy;

        [CommandProperty(AccessLevel.GameMaster)]
        public int WithdrawIncrement { get { return m_WithdrawIncrement; } set { m_WithdrawIncrement = value; } }

        [CommandProperty(AccessLevel.GameMaster)]
        public int TotalRefreshPotion { get { return m_TotalRefreshPotion; } set { m_TotalRefreshPotion = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int GreaterAgilityPotion { get { return m_GreaterAgilityPotion; } set { m_GreaterAgilityPotion = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int NightSightPotion { get { return m_NightSightPotion; } set { m_NightSightPotion = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int GreaterHealPotion { get { return m_GreaterHealPotion; } set { m_GreaterHealPotion = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int GreaterStrengthPotion { get { return m_GreaterStrengthPotion; } set { m_GreaterStrengthPotion = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int GreaterPoisonPotion { get { return m_GreaterPoisonPotion; } set { m_GreaterPoisonPotion = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int DeadlyPoisonPotion { get { return m_DeadlyPoisonPotion; } set { m_DeadlyPoisonPotion = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int LethalPoisonPotion { get { return m_LethalPoisonPotion; } set { m_LethalPoisonPotion = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int GreaterCurePotion { get { return m_GreaterCurePotion; } set { m_GreaterCurePotion = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int GreaterExplosionPotion { get { return m_GreaterExplosionPotion; } set { m_GreaterExplosionPotion = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int SmokeBomb { get { return m_SmokeBomb; } set { m_SmokeBomb = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int ManaPotion { get { return m_ManaPotion; } set { m_ManaPotion = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int TotalManaRefreshPotion { get { return m_TotalManaRefreshPotion; } set { m_TotalManaRefreshPotion = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int ShrinkPotions { get { return m_ShrinkPotions; } set { m_ShrinkPotions = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int PetResurrectPotion { get { return m_PetResurrectPotion; } set { m_PetResurrectPotion = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int RepairPotion { get { return m_RepairPotion; } set { m_RepairPotion = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int SuperPotion { get { return m_SuperPotion; } set { m_SuperPotion = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int MortarPestle { get { return m_MortarPestle; } set { m_MortarPestle = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int Bottle { get { return m_Bottle; } set { m_Bottle = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int KulickyCesnek { get { return m_KulickyCesnek; } set { m_KulickyCesnek = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int KulickyPikant { get { return m_KulickyPikant; } set { m_KulickyPikant = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int Medovina { get { return m_Medovina; } set { m_Medovina = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int ZoogiVejce { get { return m_ZoogiVejce; } set { m_ZoogiVejce = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int PekelnyParek { get { return m_PekelnyParek; } set { m_PekelnyParek = value; } }
        [CommandProperty(AccessLevel.GameMaster)]
        public int Slzy { get { return m_Slzy; } set { m_Slzy = value; } }

        public override bool DisplaysContent { get { return false; } }
        public override bool DisplayWeight { get { return true; } }

        [Constructable]
        public PotionPouch()
            : base(0xE79)
        {
            Movable = true;
            Weight = 10.0;
            Hue = 26;
            Name = "Brasna na lektvary";
            WithdrawIncrement = 10;
            LootType = LootType.Blessed;
        }

        [Constructable]
        public PotionPouch(int withdrawincrement)
            : base(0xE80)
        {
            Movable = true;
            Weight = 10.0;
            Hue = 26;
            Name = "Brasna na lektvary";
            WithdrawIncrement = withdrawincrement;
            LootType = LootType.Blessed;
        }

        public class OpenGumpEntry : ContextMenuEntry
        {
            private Mobile m_From;
            private PotionPouch i_Cont;

            public OpenGumpEntry(Mobile from, PotionPouch cont) : base(6122)
            {
                m_From = from;
                i_Cont = cont;
            }

            public override void OnClick()
            {
                if (m_From is PlayerMobile && m_From.AccessLevel > AccessLevel.Player)
                {
                    m_From.SendGump(new PotionPouchGump((PlayerMobile)m_From, i_Cont));
                }
            }
        }

        public override void GetContextMenuEntries(Mobile from, List<ContextMenuEntry> list)
        {
            if (from.AccessLevel > AccessLevel.Player)
            {
                list.Add(new OpenGumpEntry(from, this));
            }

            base.GetContextMenuEntries(from, list);
        }

        public override void OnDoubleClick(Mobile from)
        {
            if (from.AccessLevel > AccessLevel.Player)
            {
                from.SendGump(new PotionPouchGump((PlayerMobile)from, this));
                return;
            }

            if (!from.InRange(GetWorldLocation(), 2))
                from.LocalOverheadMessage(Network.MessageType.Regular, 0x3B2, 1019045); // I can't reach that.
            else if (from is PlayerMobile)
            {
                from.SendGump(new PotionPouchGump((PlayerMobile)from, this));
            }
        }

        public override bool OnDragDrop(Mobile from, Item o)
        {
            //start drag drop
            if (o is TotalRefreshPotion)
            {

                if (TotalRefreshPotion >= 9999)
                    from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    TotalRefreshPotion += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("Lektvar byl vlozen.");
                    return true;
                }
            }
            if (o is GreaterAgilityPotion)
            {

                if (GreaterAgilityPotion >= 9999)
                    from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    GreaterAgilityPotion += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("Lektvar byl vlozen.");
                    return true;
                }
            }
            if (o is NightSightPotion)
            {

                if (NightSightPotion >= 9999)
                    from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    NightSightPotion += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("Lektvar byl vlozen.");
                    return true;
                }
            }
            if (o is GreaterHealPotion)
            {

                if (GreaterHealPotion >= 9999)
                    from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    GreaterHealPotion += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("Lektvar byl vlozen.");
                    return true;
                }
            }
            if (o is GreaterStrengthPotion)
            {

                if (GreaterStrengthPotion >= 9999)
                    from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    GreaterStrengthPotion += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("Lektvar byl vlozen.");
                    return true;
                }
            }
            if (o is GreaterPoisonPotion)
            {

                if (GreaterPoisonPotion >= 9999)
                    from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    GreaterPoisonPotion += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("Lektvar byl vlozen.");
                    return true;
                }
            }
            if (o is DeadlyPoisonPotion)
            {

                if (DeadlyPoisonPotion >= 9999)
                    from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    DeadlyPoisonPotion += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("Lektvar byl vlozen.");
                    return true;
                }
            }
            if (o is LethalPoisonPotion)
            {

                if (LethalPoisonPotion >= 9999)
                    from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    LethalPoisonPotion += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("Lektvar byl vlozen.");
                    return true;
                }
            }
            if (o is GreaterCurePotion)
            {

                if (GreaterCurePotion >= 9999)
                    from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    GreaterCurePotion += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("Lektvar byl vlozen.");
                    return true;
                }
            }
            if (o is GreaterExplosionPotion)
            {

                if (GreaterExplosionPotion >= 9999)
                    from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    GreaterExplosionPotion += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("Lektvar byl vlozen.");
                    return true;
                }
            }
            if (o is SmokeBomb)
            {

                if (SmokeBomb >= 9999)
                    from.SendMessage("Vice techto predmetu se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    SmokeBomb += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("Predmet byl vlozen.");
                    return true;
                }
            }
            if (o is ManaPotion)
            {

                if (ManaPotion >= 9999)
                    from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    ManaPotion += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("Lektvar byl vlozen.");
                    return true;
                }
            }
            if (o is TotalManaRefreshPotion)
            {

                if (TotalManaRefreshPotion >= 9999)
                    from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    TotalManaRefreshPotion += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("Lektvar byl vlozen.");
                    return true;
                }
            }
            if (o is ShrinkPotions)
            {

                if (ShrinkPotions >= 9999)
                    from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    ShrinkPotions += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("Lektvar byl vlozen.");
                    return true;
                }
            }
            if (o is PetResurrectPotion)
            {

                if (PetResurrectPotion >= 9999)
                    from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    PetResurrectPotion += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("Lektvar byl vlozen.");
                    return true;
                }
            }
            if (o is RepairPotion)
            {

                if (RepairPotion >= 9999)
                    from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    RepairPotion += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("Lektvar byl vlozen.");
                    return true;
                }
            }
            if (o is SuperPotion)
            {

                if (SuperPotion >= 9999)
                    from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    SuperPotion += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("Lektvar byl vlozen.");
                    return true;
                }
            }
            if (o is MortarPestle)
            {
                if (MortarPestle > (9999 - ((BaseTool)o).UsesRemaining))
                    from.SendMessage("Vice hmozdiru se do brasny jiz nevejde.");
                else
                {
                    MortarPestle = (MortarPestle + ((BaseTool)o).UsesRemaining);
                    ((Item)o).Delete();
                    from.SendMessage("Hmozdir byl vlozen.");
                    return true;
                }
            }
            if (o is Bottle)
            {

                if (Bottle >= 9999)
                    from.SendMessage("Vice prazdnych lahvi se do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    Bottle += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("{0}.", (curItem.Amount > 1) ? "Lahvicky byly vlozeny" : "Lahvicka byla vlozena");
                    return true;
                }
            }
            if (o is KulickyCesnek)
            {

                if (KulickyCesnek >= 9999)
                    from.SendMessage("Vice tohoto predmetu se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    KulickyCesnek += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("{0}.", (curItem.Amount > 1) ? "Cesnekove kulicky byly vlozeny" : "Cesnekova kulicka byla vlozena");
                    return true;
                }
            }
            if (o is KulickyPikant)
            {

                if (KulickyPikant >= 9999)
                    from.SendMessage("Vice tohoto predmetu se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    KulickyPikant += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("{0}.", (curItem.Amount > 1) ? "Pikantni kulicky byly vlozeny" : "Pikantni kulicka byla vlozena");
                    return true;
                }
            }
            if (o is Medovina)
            {

                if (Medovina >= 9999)
                    from.SendMessage("Vice tohoto predmetu se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    Medovina += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("{0}.", (curItem.Amount > 1) ? "Medoviny byly vlozeny" : "Medovina byla vlozena");
                    return true;
                }
            }
            if (o is ZoogiVejce)
            {

                if (ZoogiVejce >= 9999)
                    from.SendMessage("Vice tohoto predmetu se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    ZoogiVejce += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("{0}.", (curItem.Amount > 1) ? "Zoogi Vejce byly vlozeny" : "Zoogi Vejce bylo vlozeno");
                    return true;
                }
            }
            if (o is PekelnyParek)
            {

                if (PekelnyParek >= 9999)
                    from.SendMessage("Vice tohoto predmetu se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    PekelnyParek += curItem.Amount;
                    from.SendMessage("{0}.", (curItem.Amount > 1) ? "Pekelne parky byly vlozeny" : "Pekelny parek byl vlozen");
                    curItem.Delete();
                    return true;
                }
            }
            if (o is SlzaAuberonu)
            {

                if (Slzy >= 9999)
                    from.SendMessage("Vice tohoto predmetu se jiz do brasny nevejde.");
                else
                {
                    Item curItem = o as Item;
                    Slzy += curItem.Amount;
                    curItem.Delete();
                    from.SendMessage("Predmet byl vlozen.");
                    return true;
                }
            }

            if (from.HasGump(typeof(PotionPouchGump)))
            {
                from.CloseGump(typeof(PotionPouchGump));
                from.SendGump(new PotionPouchGump((PlayerMobile)from, this));
            }
            return false;
            //end drag drop
        }

        public void BeginCombine(Mobile from)
        {
            from.Target = new PotionPouchTarget(this);
        }

        public void EndCombine(Mobile from, object o)
        {
            if (o is Item && ((Item)o).IsChildOf(from.Backpack))
            {
                if (o is TotalRefreshPotion)
                {

                    if (TotalRefreshPotion >= 9999)
                        from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        TotalRefreshPotion += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is GreaterAgilityPotion)
                {

                    if (GreaterAgilityPotion >= 9999)
                        from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        GreaterAgilityPotion += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is NightSightPotion)
                {

                    if (NightSightPotion >= 9999)
                        from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        NightSightPotion += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is GreaterHealPotion)
                {

                    if (GreaterHealPotion >= 9999)
                        from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        GreaterHealPotion += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is GreaterStrengthPotion)
                {

                    if (GreaterStrengthPotion >= 9999)
                        from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        GreaterStrengthPotion += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is GreaterPoisonPotion)
                {

                    if (GreaterPoisonPotion >= 9999)
                        from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        GreaterPoisonPotion += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is DeadlyPoisonPotion)
                {

                    if (DeadlyPoisonPotion >= 9999)
                        from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        DeadlyPoisonPotion += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is LethalPoisonPotion)
                {

                    if (LethalPoisonPotion >= 9999)
                        from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        LethalPoisonPotion += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is GreaterCurePotion)
                {

                    if (GreaterCurePotion >= 9999)
                        from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        GreaterCurePotion += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is GreaterExplosionPotion)
                {

                    if (GreaterExplosionPotion >= 9999)
                        from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        GreaterExplosionPotion += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is SmokeBomb)
                {

                    if (SmokeBomb >= 9999)
                        from.SendMessage("Vice techto predmetu se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        SmokeBomb += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is ManaPotion)
                {

                    if (ManaPotion >= 9999)
                        from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        ManaPotion += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is TotalManaRefreshPotion)
                {

                    if (TotalManaRefreshPotion >= 9999)
                        from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        TotalManaRefreshPotion += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is ShrinkPotions)
                {

                    if (ShrinkPotions >= 9999)
                        from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        ShrinkPotions += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is PetResurrectPotion)
                {

                    if (PetResurrectPotion >= 9999)
                        from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        PetResurrectPotion += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is RepairPotion)
                {

                    if (RepairPotion >= 9999)
                        from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        RepairPotion += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is SuperPotion)
                {

                    if (SuperPotion >= 9999)
                        from.SendMessage("Vice tohoto lektvaru se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        SuperPotion += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is MortarPestle)
                {
                    if (MortarPestle > (9999 - ((BaseTool)o).UsesRemaining))
                        from.SendMessage("Vice hmizdiru se do brasny jiz nevejde.");
                    else
                    {
                        MortarPestle = (MortarPestle + ((BaseTool)o).UsesRemaining);
                        ((Item)o).Delete();
                    }
                }
                if (o is Bottle)
                {

                    if (Bottle >= 9999)
                        from.SendMessage("Vice prazdnych lahvi se do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        Bottle += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is KulickyCesnek)
                {

                    if (KulickyCesnek >= 9999)
                        from.SendMessage("Vice tohoto predmetu se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        KulickyCesnek += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is KulickyPikant)
                {

                    if (KulickyPikant >= 9999)
                        from.SendMessage("Vice tohoto predmetu se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        KulickyPikant += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is Medovina)
                {

                    if (Medovina >= 9999)
                        from.SendMessage("Vice tohoto predmetu se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        Medovina += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is ZoogiVejce)
                {

                    if (ZoogiVejce >= 9999)
                        from.SendMessage("Vice tohoto predmetu se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        ZoogiVejce += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is PekelnyParek)
                {

                    if (PekelnyParek >= 9999)
                        from.SendMessage("Vice tohoto predmetu se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        PekelnyParek += curItem.Amount;
                        curItem.Delete();
                    }
                }
                if (o is SlzaAuberonu)
                {

                    if (Slzy >= 9999)
                        from.SendMessage("Vice tohoto predmetu se jiz do brasny nevejde.");
                    else
                    {
                        Item curItem = o as Item;
                        Slzy += curItem.Amount;
                        curItem.Delete();
                    }
                }

                //start potion keg
                if (o is PotionKeg)
                {
                    PotionKeg keg = (PotionKeg)o;
                    PotionEffect type = keg.Type;
                    int held = keg.Held;

                    if (keg != null && !keg.Deleted && held > 0 &&
                        ((type == PotionEffect.Nightsight && (NightSightPotion + held) < 10000)
                         || (type == PotionEffect.CureGreater && (GreaterCurePotion + held) < 10000) || (type == PotionEffect.AgilityGreater && (GreaterAgilityPotion + held) < 10000)
                         || (type == PotionEffect.StrengthGreater && (GreaterStrengthPotion + held) < 10000) || (type == PotionEffect.PoisonGreater && (GreaterPoisonPotion + held) < 10000)
                         || (type == PotionEffect.PoisonDeadly && (DeadlyPoisonPotion + held) < 10000) || (type == PotionEffect.PoisonLethal && (LethalPoisonPotion + held) < 10000)
                         || (type == PotionEffect.RefreshTotal && (TotalRefreshPotion + held) < 10000) || (type == PotionEffect.SuperPotion && (SuperPotion + held) < 10000)
                         || (type == PotionEffect.HealGreater && (GreaterHealPotion + held) < 10000) || (type == PotionEffect.ExplosionGreater && (GreaterExplosionPotion + held) < 10000)
                         || (type == PotionEffect.Mana && (ManaPotion + held) < 10000) || (type == PotionEffect.TotalManaRefresh && (TotalManaRefreshPotion + held) < 10000)
                         || (type == PotionEffect.PetResurrect && (PetResurrectPotion + held) < 10000) || (type == PotionEffect.Repair && (RepairPotion + held) < 10000)))
                    {
                        if (held > Bottle)
                            from.SendMessage("Musis mit v brasne minimalne {0} prazdnych lahvi, aby bylo mozne keg prelit.", held);
                        else
                        {
                            switch (type)
                            {
                                default:
                                case PotionEffect.Nightsight: NightSightPotion += held; break;
                                case PotionEffect.CureGreater: GreaterCurePotion += held; break;
                                case PotionEffect.AgilityGreater: GreaterAgilityPotion += held; break;
                                case PotionEffect.StrengthGreater: GreaterStrengthPotion += held; break;
                                case PotionEffect.PoisonGreater: GreaterPoisonPotion += held; break;
                                case PotionEffect.PoisonDeadly: DeadlyPoisonPotion += held; break;
                                case PotionEffect.PoisonLethal: LethalPoisonPotion += held; break;
                                case PotionEffect.RefreshTotal: TotalRefreshPotion += held; break;
                                case PotionEffect.HealGreater: GreaterHealPotion += held; break;
                                case PotionEffect.ExplosionGreater: GreaterExplosionPotion += held; break;
                                case PotionEffect.Mana: ManaPotion += held; break;
                                case PotionEffect.TotalManaRefresh: TotalManaRefreshPotion += held; break;
                                case PotionEffect.PetResurrect: PetResurrectPotion += held; break;
                                case PotionEffect.Repair: RepairPotion += held; break;
                                case PotionEffect.SuperPotion: SuperPotion += held; break;
                            }
                            Bottle -= held;
                            keg.Delete();
                            from.AddToBackpack(new PotionKeg());
                            from.SendMessage("Keg byl prelit do prazdnych lahvi v brasne.");
                        }
                    }
                    else
                        from.SendMessage("Tento druh lektvaru nejde do brasny vlozit, brasna je plna, nebo je keg prazdny.");
                }
                //end potion keg
                from.SendGump(new PotionPouchGump((PlayerMobile)from, this));
                BeginCombine(from);
            }
            else
            {
                from.SendLocalizedMessage(1045158); // You must have the item in your backpack to target it.
            }
        }

        public PotionPouch(Serial serial)
            : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)3); // version

            writer.Write((int)m_Slzy);

            writer.Write((int)m_PekelnyParek);

            writer.Write((int)m_LethalPoisonPotion);
            writer.Write((int)m_KulickyCesnek);
            writer.Write((int)m_KulickyPikant);
            writer.Write((int)m_Medovina);
            writer.Write((int)m_ZoogiVejce);

            writer.Write((int)m_TotalRefreshPotion);
            writer.Write((int)m_GreaterAgilityPotion);
            writer.Write((int)m_NightSightPotion);
            writer.Write((int)m_GreaterHealPotion);
            writer.Write((int)m_GreaterStrengthPotion);
            writer.Write((int)m_GreaterPoisonPotion);
            writer.Write((int)m_DeadlyPoisonPotion);
            writer.Write((int)m_GreaterCurePotion);
            writer.Write((int)m_GreaterExplosionPotion);
            writer.Write((int)m_SmokeBomb);
            writer.Write((int)m_ManaPotion);
            writer.Write((int)m_TotalManaRefreshPotion);
            writer.Write((int)m_ShrinkPotions);
            writer.Write((int)m_PetResurrectPotion);
            writer.Write((int)m_RepairPotion);
            writer.Write((int)m_SuperPotion);
            writer.Write((int)m_MortarPestle);
            writer.Write((int)m_Bottle);
            writer.Write((int)m_WithdrawIncrement);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();

            switch (version)
            {
                case 3:
                    {
                        m_Slzy = reader.ReadInt();
                        goto case 2;
                    }
                case 2:
                    {
                        m_PekelnyParek = reader.ReadInt();
                        goto case 1;
                    }
                case 1:
                    {
                        m_LethalPoisonPotion = reader.ReadInt();
                        m_KulickyCesnek = reader.ReadInt();
                        m_KulickyPikant = reader.ReadInt();
                        m_Medovina = reader.ReadInt();
                        m_ZoogiVejce = reader.ReadInt();
                        goto case 0;
                    }
                case 0:
                    {
                        m_TotalRefreshPotion = reader.ReadInt();
                        m_GreaterAgilityPotion = reader.ReadInt();
                        m_NightSightPotion = reader.ReadInt();
                        m_GreaterHealPotion = reader.ReadInt();
                        m_GreaterStrengthPotion = reader.ReadInt();
                        m_GreaterPoisonPotion = reader.ReadInt();
                        m_DeadlyPoisonPotion = reader.ReadInt();
                        m_GreaterCurePotion = reader.ReadInt();
                        m_GreaterExplosionPotion = reader.ReadInt();
                        m_SmokeBomb = reader.ReadInt();
                        m_ManaPotion = reader.ReadInt();
                        m_TotalManaRefreshPotion = reader.ReadInt();
                        m_ShrinkPotions = reader.ReadInt();
                        m_PetResurrectPotion = reader.ReadInt();
                        m_RepairPotion = reader.ReadInt();
                        m_SuperPotion = reader.ReadInt();
                        m_MortarPestle = reader.ReadInt();
                        m_Bottle = reader.ReadInt();
                        m_WithdrawIncrement = reader.ReadInt();
                        break;
                    }
            }
        }
    }
}


namespace Server.Items
{
    public class PotionPouchGump : Gump
    {
        private PlayerMobile m_From;
        private PotionPouch m_Box;

        public PotionPouchGump(PlayerMobile from, PotionPouch box)
            : base(25, 25)
        {
            m_From = from;
            m_Box = box;

            m_From.CloseGump(typeof(PotionPouchGump));

            AddPage(0);

            AddBackground(12, 19, 486, 357, 9250);
            AddLabel(200, 30, 32, @"Brasna na lektvary");

            AddLabel(60, 50, 32, @"Vlozit predmet");
            AddButton(25, 50, 4005, 4007, 1, GumpButtonType.Reply, 0);

            AddLabel(60, 75, 32, @"Zavrit");
            AddButton(25, 75, 4005, 4007, 0, GumpButtonType.Reply, 0);

            AddLabel(60, 115, 1359, @"Greater Heal");
            AddLabel(185, 115, 0x480, box.GreaterHealPotion.ToString());
            AddButton(25, 115, 4005, 4007, 3, GumpButtonType.Reply, 0);

            AddLabel(60, 135, 2116, @"Greater Cure");
            AddLabel(185, 135, 0x480, box.GreaterCurePotion.ToString());
            AddButton(25, 135, 4005, 4007, 4, GumpButtonType.Reply, 0);

            AddLabel(60, 155, 1171, @"Total Refresh");
            AddLabel(185, 155, 0x480, box.TotalRefreshPotion.ToString());
            AddButton(25, 155, 4005, 4007, 5, GumpButtonType.Reply, 0);

            AddLabel(60, 175, 1149, @"Greater Strenght");
            AddLabel(185, 175, 0x480, box.GreaterStrengthPotion.ToString());
            AddButton(25, 175, 4005, 4007, 6, GumpButtonType.Reply, 0);

            AddLabel(60, 195, 1163, @"Greater Poison");
            AddLabel(185, 195, 0x480, box.GreaterPoisonPotion.ToString());
            AddButton(25, 195, 4005, 4007, 7, GumpButtonType.Reply, 0);

            AddLabel(60, 215, 761, @"Deadly Poison");
            AddLabel(185, 215, 0x480, box.DeadlyPoisonPotion.ToString());
            AddButton(25, 215, 4005, 4007, 8, GumpButtonType.Reply, 0);

            AddLabel(60, 235, 1192, @"Lethal Poison");
            AddLabel(185, 235, 0x480, box.LethalPoisonPotion.ToString());
            AddButton(25, 235, 4005, 4007, 21, GumpButtonType.Reply, 0);

            AddLabel(60, 255, 2405, @"NightSight");
            AddLabel(185, 255, 0x480, box.NightSightPotion.ToString());
            AddButton(25, 255, 4005, 4007, 10, GumpButtonType.Reply, 0);

            AddLabel(60, 275, 2218, @"Greater Agility");
            AddLabel(185, 275, 0x480, box.GreaterAgilityPotion.ToString());
            AddButton(25, 275, 4005, 4007, 11, GumpButtonType.Reply, 0);

            AddLabel(60, 300, 144, @"Zoogi Vejce");
            AddLabel(185, 300, 0x480, box.ZoogiVejce.ToString());
            AddButton(25, 300, 4005, 4007, 22, GumpButtonType.Reply, 0);

            AddLabel(60, 320, 144, @"Leciva Medovina");
            AddLabel(185, 320, 0x480, box.Medovina.ToString());
            AddButton(25, 320, 4005, 4007, 23, GumpButtonType.Reply, 0);

            AddLabel(60, 340, 144, @"Pekelny Parek");
            AddLabel(185, 340, 0x480, box.PekelnyParek.ToString());
            AddButton(25, 340, 4005, 4007, 26, GumpButtonType.Reply, 0);

            // druhej sloupek

            AddLabel(300, 95, 28, @"Greater Explosion");
            AddLabel(425, 95, 0x480, box.GreaterExplosionPotion.ToString());
            AddButton(265, 95, 4005, 4007, 9, GumpButtonType.Reply, 0);

            AddLabel(300, 115, 6, @"Mana Potion");
            AddLabel(425, 115, 0x480, box.ManaPotion.ToString());
            AddButton(265, 115, 4005, 4007, 12, GumpButtonType.Reply, 0);

            AddLabel(300, 135, 1155, @"Total Mana");
            AddLabel(425, 135, 0x480, box.TotalManaRefreshPotion.ToString());
            AddButton(265, 135, 4005, 4007, 13, GumpButtonType.Reply, 0);

            AddLabel(300, 155, 2417, @"Shrink");
            AddLabel(425, 155, 0x480, box.ShrinkPotions.ToString());
            AddButton(265, 155, 4005, 4007, 14, GumpButtonType.Reply, 0);

            AddLabel(300, 175, 871, @"Pet Resurrect");
            AddLabel(425, 175, 0x480, box.PetResurrectPotion.ToString());
            AddButton(265, 175, 4005, 4007, 15, GumpButtonType.Reply, 0);

            AddLabel(300, 195, 1108, @"Repair");
            AddLabel(425, 195, 0x480, box.RepairPotion.ToString());
            AddButton(265, 195, 4005, 4007, 16, GumpButtonType.Reply, 0);

            AddLabel(300, 215, 1157, @"Revitalize");
            AddLabel(425, 215, 0x480, box.SuperPotion.ToString());
            AddButton(265, 215, 4005, 4007, 17, GumpButtonType.Reply, 0);

            AddLabel(300, 235, 990, @"Smoke Bomb");
            AddLabel(425, 235, 0x480, box.SmokeBomb.ToString());
            AddButton(265, 235, 4005, 4007, 18, GumpButtonType.Reply, 0);

            AddLabel(300, 255, 2412, @"Mortar & Pestle");
            AddLabel(425, 255, 0x480, box.MortarPestle.ToString());
            AddButton(265, 255, 4005, 4007, 19, GumpButtonType.Reply, 0);

            AddLabel(300, 275, 0, @"Empty Bottles");
            AddLabel(425, 275, 0x480, box.Bottle.ToString());
            AddButton(265, 275, 4005, 4007, 20, GumpButtonType.Reply, 0);

            AddLabel(300, 300, 144, @"Cesnekove Kulicky");
            AddLabel(425, 300, 0x480, box.KulickyCesnek.ToString());
            AddButton(265, 300, 4005, 4007, 24, GumpButtonType.Reply, 0);

            AddLabel(300, 320, 144, @"Pikantni Kulicky");
            AddLabel(425, 320, 0x480, box.KulickyPikant.ToString());
            AddButton(265, 320, 4005, 4007, 25, GumpButtonType.Reply, 0);

            AddLabel(300, 340, 1165, @"Slza Auberonu");
            AddLabel(425, 340, 0x480, box.Slzy.ToString());
            AddButton(265, 340, 4005, 4007, 27, GumpButtonType.Reply, 0);
        }

        public override void OnResponse(NetState sender, RelayInfo info)
        {
            if (m_Box.Deleted)
                return;
            else if (!m_From.InRange(m_Box.GetWorldLocation(), 2))
            {
                m_From.SendMessage("Jsi od {0} prilis daleko!", m_Box.Name);
                if (m_From.HasGump(typeof(PotionPouchGump)))
                    m_From.CloseGump(typeof(PotionPouchGump));
                return;
            }

            if (info.ButtonID == 1)
            {
                m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                m_Box.BeginCombine(m_From);
            }

            if (info.ButtonID == 3)
            {
                if (m_Box.GreaterHealPotion > 0)
                {
                    m_From.AddToBackpack(new GreaterHealPotion());                      //Sends all stored Granites of whichever type to players backpack
                    m_Box.GreaterHealPotion = m_Box.GreaterHealPotion - 1;                                                  //Sets the count in the key back to 0
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));                    //Resets the gump with the new info
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento lektvar!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }

            if (info.ButtonID == 4)
            {
                if (m_Box.GreaterCurePotion > 0)
                {
                    m_From.AddToBackpack(new GreaterCurePotion());
                    m_Box.GreaterCurePotion = m_Box.GreaterCurePotion - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento lektvar!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 5)
            {
                if (m_Box.TotalRefreshPotion > 0)
                {
                    m_From.AddToBackpack(new TotalRefreshPotion());
                    m_Box.TotalRefreshPotion = m_Box.TotalRefreshPotion - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento lektvar!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 6)
            {
                if (m_Box.GreaterStrengthPotion > 0)
                {
                    m_From.AddToBackpack(new GreaterStrengthPotion());
                    m_Box.GreaterStrengthPotion = m_Box.GreaterStrengthPotion - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento lektvar!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 7)
            {
                if (m_Box.GreaterPoisonPotion > 0)
                {
                    m_From.AddToBackpack(new GreaterPoisonPotion());
                    m_Box.GreaterPoisonPotion = m_Box.GreaterPoisonPotion - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento lektvar!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 8)
            {
                if (m_Box.DeadlyPoisonPotion > 0)
                {
                    m_From.AddToBackpack(new DeadlyPoisonPotion());
                    m_Box.DeadlyPoisonPotion = m_Box.DeadlyPoisonPotion - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento lektvar!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 9)
            {
                if (m_Box.GreaterExplosionPotion > 0)
                {
                    m_From.AddToBackpack(new GreaterExplosionPotion());
                    m_Box.GreaterExplosionPotion = m_Box.GreaterExplosionPotion - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento lektvar!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 10)
            {
                if (m_Box.NightSightPotion > 0)
                {
                    m_From.AddToBackpack(new NightSightPotion());
                    m_Box.NightSightPotion = m_Box.NightSightPotion - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento lektvar!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 11)
            {
                if (m_Box.GreaterAgilityPotion > 0)
                {
                    m_From.AddToBackpack(new GreaterAgilityPotion());
                    m_Box.GreaterAgilityPotion = m_Box.GreaterAgilityPotion - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento lektvar!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 12)
            {
                if (m_Box.ManaPotion > 0)
                {
                    m_From.AddToBackpack(new ManaPotion());
                    m_Box.ManaPotion = m_Box.ManaPotion - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento lektvar!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 13)
            {
                if (m_Box.TotalManaRefreshPotion > 0)
                {
                    m_From.AddToBackpack(new TotalManaRefreshPotion());
                    m_Box.TotalManaRefreshPotion = m_Box.TotalManaRefreshPotion - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento lektvar!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 14)
            {
                if (m_Box.ShrinkPotions > 0)
                {
                    m_From.AddToBackpack(new ShrinkPotions());
                    m_Box.ShrinkPotions = m_Box.ShrinkPotions - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento lektvar!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 15)
            {
                if (m_Box.PetResurrectPotion > 0)
                {
                    m_From.AddToBackpack(new PetResurrectPotion());
                    m_Box.PetResurrectPotion = m_Box.PetResurrectPotion - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento lektvar!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 16)
            {
                if (m_Box.RepairPotion > 0)
                {
                    m_From.AddToBackpack(new RepairPotion());
                    m_Box.RepairPotion = m_Box.RepairPotion - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento lektvar!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 17)
            {
                if (m_Box.SuperPotion > 0)
                {
                    m_From.AddToBackpack(new SuperPotion());
                    m_Box.SuperPotion = m_Box.SuperPotion - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento lektvar!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }

            if (info.ButtonID == 18)
            {
                if (m_Box.SmokeBomb > 0)
                {
                    m_From.AddToBackpack(new SmokeBomb());
                    m_Box.SmokeBomb = m_Box.SmokeBomb - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento lektvar!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 19)
            {
                if (m_Box.MortarPestle > 0)
                {
                    m_From.AddToBackpack(new MortarPestle(m_Box.MortarPestle));
                    m_Box.MortarPestle = (0);
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("Nemas v brasne uz zadny tento predmet!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 20)
            {
                if (m_Box.Bottle > m_Box.WithdrawIncrement)
                {
                    m_From.AddToBackpack(new Bottle(m_Box.WithdrawIncrement));
                    m_Box.Bottle = m_Box.Bottle - m_Box.WithdrawIncrement;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else if (m_Box.Bottle > 0)
                {
                    m_From.AddToBackpack(new Bottle(m_Box.Bottle));
                    m_Box.Bottle = 0;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("Nemas v brasne uz zadne prazdne lahve!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 21)
            {
                if (m_Box.LethalPoisonPotion > 0)
                {
                    m_From.AddToBackpack(new LethalPoisonPotion());
                    m_Box.LethalPoisonPotion = m_Box.LethalPoisonPotion - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento lektvar!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 22)
            {
                if (m_Box.ZoogiVejce > 0)
                {
                    m_From.AddToBackpack(new ZoogiVejce());
                    m_Box.ZoogiVejce = m_Box.ZoogiVejce - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento predmet!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 23)
            {
                if (m_Box.Medovina > 0)
                {
                    m_From.AddToBackpack(new Medovina());
                    m_Box.Medovina = m_Box.Medovina - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento predmet!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 24)
            {
                if (m_Box.KulickyCesnek > 0)
                {
                    m_From.AddToBackpack(new KulickyCesnek());
                    m_Box.KulickyCesnek = m_Box.KulickyCesnek - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento predmet!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 25)
            {
                if (m_Box.KulickyPikant > 0)
                {
                    m_From.AddToBackpack(new KulickyPikant());
                    m_Box.KulickyPikant = m_Box.KulickyPikant - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento predmet!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 26)
            {
                if (m_Box.PekelnyParek > 0)
                {
                    m_From.AddToBackpack(new PekelnyParek());
                    m_Box.PekelnyParek = m_Box.PekelnyParek - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento predmet!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
            if (info.ButtonID == 27)
            {
                if (m_Box.Slzy > 0)
                {
                    m_From.AddToBackpack(new SlzaAuberonu());
                    m_Box.Slzy = m_Box.Slzy - 1;
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                }
                else
                {
                    m_From.SendMessage("V brasne jiz nemas zadny tento predmet!");
                    m_From.SendGump(new PotionPouchGump(m_From, m_Box));
                    m_Box.BeginCombine(m_From);
                }
            }
        }
    }

}

namespace Server.Items
{
    public class PotionPouchTarget : Target
    {
        private PotionPouch m_Box;

        public PotionPouchTarget(PotionPouch box)
            : base(18, false, TargetFlags.None)
        {
            m_Box = box;
        }

        protected override void OnTarget(Mobile from, object targeted)
        {
            if (m_Box.Deleted)
                return;

            m_Box.EndCombine(from, targeted);
        }
    }
}
